﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private rand As New Random()
    Private numTaps As Integer = 0
    Private appService As PhoneApplicationService = PhoneApplicationService.Current


    Public Sub New()
        InitializeComponent()
        UpdatePageTitle(numTaps)
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        ContentPanel.Background = New SolidColorBrush(Color.FromArgb(255, CByte(rand.Next(256)),
                                                                          CByte(rand.Next(256)),
                                                                          CByte(rand.Next(256))))
        numTaps += 1
        UpdatePageTitle(numTaps)

        args.Complete()
        MyBase.OnManipulationStarted(args)
    End Sub


    Private Sub UpdatePageTitle(ByVal numTaps As Integer)
        PageTitle.Text = String.Format("{0} taps total", numTaps)
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        appService.State("numTaps") = numTaps

        If TypeOf ContentPanel.Background Is SolidColorBrush Then
            appService.State("backgroundColor") =
                (TryCast(ContentPanel.Background, SolidColorBrush)).Color
        End If

        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        ' Load numTaps 
        If appService.State.ContainsKey("numTaps") Then
            Int32.TryParse(appService.State("numTaps").ToString(), numTaps)
            UpdatePageTitle(numTaps)
        End If

        ' Load background color
        Dim obj = Nothing

        If appService.State.TryGetValue("backgroundColor", obj) Then
            ContentPanel.Background = New SolidColorBrush(CType(obj, Color))
        End If

        MyBase.OnNavigatedTo(args)
    End Sub
End Class
